<?php
$cookie_email = !empty(get_cookie("c_cookie_email")) ? encrypt_decode(get_cookie("c_cookie_email")) : "";
$cookie_pass  = !empty(get_cookie("c_cookie_pass")) ? encrypt_decode(get_cookie("c_cookie_pass")) : "";
$redirect     = session('ref_url') ?? user_url();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Sign In</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
*{box-sizing:border-box}
body{
  margin:0;
  font-family:'Poppins',sans-serif;
  background:linear-gradient(135deg,#6a11cb,#8e2de2);
  min-height:100vh;
  overflow:hidden;
}

/* PARTICLE */
#fx{
  position:fixed;
  inset:0;
  z-index:1;
  pointer-events:none;
}

/* PAGE */
.page{
  position:relative;
  z-index:2;
  min-height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:40px;
}

/* WRAPPER */
.wrapper{
  width:100%;
  max-width:1100px;
  background:#fff;
  border-radius:22px;
  display:flex;
  overflow:hidden;
  box-shadow:0 40px 90px rgba(0,0,0,.3);
}

/* LEFT */
.left{
  flex:1.3;
  background:#f6f3ff;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:40px;
}
.left img{
  max-width:100%;
  transition:.4s ease;
}

/* RIGHT */
.right{
  flex:1;
  background:#7b4ce6;
  color:#fff;
  padding:50px 40px;
  display:flex;
  flex-direction:column;
  justify-content:center;
}

.right h2{
  font-size:28px;
  margin-bottom:30px;
}

/* INPUT */
.input{
  width:100%;
  height:46px;
  border:none;
  border-radius:12px;
  padding:0 15px;
  margin-bottom:15px;
  background:rgba(255,255,255,.15);
  color:#fff;
}
.input::placeholder{color:#e0d9ff}
.input:focus{
  outline:none;
  box-shadow:0 0 0 3px rgba(255,255,255,.3);
}

/* PASSWORD EYE */
.password-wrap{
  position:relative;
}
.password-wrap .eye{
  position:absolute;
  right:14px;
  top:50%;
  transform:translateY(-50%);
  cursor:pointer;
  font-size:18px;
  opacity:.85;
}

/* OPTIONS */
.options{
  display:flex;
  justify-content:space-between;
  font-size:13px;
  margin-bottom:20px;
}
.options a{
  color:#fff;
  text-decoration:none;
}

/* BUTTON */
button{
  height:46px;
  border:none;
  border-radius:14px;
  background:#ffcc00;
  color:#000;
  font-weight:600;
  cursor:pointer;
  transition:.3s;
}
button:hover{transform:translateY(-2px)}

/* SIGNUP */
.signup{
  text-align:center;
  margin-top:20px;
  font-size:14px;
}
.signup a{
  color:#ffcc00;
  text-decoration:none;
}

/* MOBILE */
@media(max-width:900px){
  .wrapper{flex-direction:column}
  .left{display:none}
}
</style>
</head>

<body>

<canvas id="fx"></canvas>

<div class="page">
  <div class="wrapper">

    <!-- LEFT -->
    <div class="left">
      <img src="<?= base_url('public/assets/img/sign-in-home.png') ?>" id="illu" alt="Login">
    </div>

    <!-- RIGHT -->
    <div class="right">

      <h2>Login</h2>

      <?= form_open(base_url('sign-in'),'class="actionForm" data-redirect="'.$redirect.'"') ?>

        <input class="input" type="email" name="email"
          placeholder="Username or Email"
          value="<?= $cookie_email ?: set_value('email') ?>" required>

        <div class="password-wrap">
          <input class="input" type="password" name="password" id="password"
            placeholder="Password"
            value="<?= $cookie_pass ?: set_value('password') ?>" required>
          <span class="eye" id="togglePass">👁️</span>
        </div>

        <div class="options">
          <label>
            <input type="checkbox" name="remember"
            <?= !empty($cookie_email) ? 'checked' : '' ?>> Remember me
          </label>
          <a href="<?= base_url('password-reset') ?>">Forgot?</a>
        </div>

        <button type="submit">LOGIN</button>

      <?= form_close(); ?>

      <div class="signup">
        New here? <a href="<?= base_url('sign-up') ?>">Sign Up</a>
      </div>

    </div>
  </div>
</div>

<script>
/* PARTICLE SPIDER EFFECT */
const c=document.getElementById("fx"),x=c.getContext("2d");
let w,h,p=[];
function resize(){w=c.width=innerWidth;h=c.height=innerHeight}
resize();addEventListener("resize",resize);

function add(x0,y0){p.push({x:x0,y:y0,l:60})}
addEventListener("mousemove",e=>add(e.x,e.y));
addEventListener("touchmove",e=>{
  let t=e.touches[0];add(t.clientX,t.clientY)
});

function draw(){
  x.clearRect(0,0,w,h);
  p.forEach((a,i)=>{
    a.l--;
    p.slice(i+1).forEach(b=>{
      let d=Math.hypot(a.x-b.x,a.y-b.y);
      if(d<120){
        x.strokeStyle=`rgba(255,255,255,${.15*(1-d/120)})`;
        x.beginPath();x.moveTo(a.x,a.y);x.lineTo(b.x,b.y);x.stroke();
      }
    });
  });
  p=p.filter(a=>a.l>0);
  requestAnimationFrame(draw);
}
draw();

/* PASSWORD TOGGLE */
const pass=document.getElementById("password");
const toggle=document.getElementById("togglePass");
toggle.onclick=()=>{
  if(pass.type==="password"){
    pass.type="text";
    toggle.textContent="🙈";
  }else{
    pass.type="password";
    toggle.textContent="👁️";
  }
};

/* IMAGE PARALLAX */
const illu=document.getElementById("illu");
document.addEventListener("mousemove",e=>{
  let x=(e.clientX/window.innerWidth-.5)*20;
  let y=(e.clientY/window.innerHeight-.5)*20;
  illu.style.transform=`translate(${x}px,${y}px)`;
});
</script>

</body>
</html>
